<?
/*
Author		: Louis
Version		: 1.00
Date		: 03 June 2002
Function	: Group Management
*/ 
session_start();
require("auth.php");
unset($msg);

######################################################
# Determine if Access Level is adequate to view page #
######################################################
if ($Transmarco["accesslevel"] < $adminlevel) {
	authfail();
}
else { 
	#######################################################################
	# Registering Sort Order into Session                                 #
	# Will control the page so that the page appears in the same sorting  #
	# order everytime the user from the same browser access the same page #
	#######################################################################
	// First time the user access the page, automatically sort by group starting range
	if (($Transmarco["userpoolsort"] == "") && ($sortorder == "")) {
		$Transmarco["userpoolsort"] = "poolend";
	}
	// Subsequently when users decide on a sorting preference, store their preference into a session
	if (($Transmarco["userpoolsort"] != "") && ($sortorder != "")) {
		$Transmarco["userpoolsort"] = $sortorder;
	}
	###################################################
	# Editing a Pool code                             #
	###################################################
	if (($action == 'Update') && ($submitted == 'yes')) {
		$msg = "";	
		// Check if Pool Description is blank when User is editing a pool
		if (trim($pooldesc) == "") {
			$msg = "<br><b>Pool Description Must Be Filled In</b>";		
		}
		
		if ($flag == "0") {
			if (trim($poolstart) == "") {
				$sql = "update pool set pooldesc='$pooldesc' where poolid=$id";
			}
			else if ((intval($poolstart) > 0) && (strlen($poolstart) == 4) && (ereg("[0-9]{4}",$poolstart))) {
				$poolstart = magiccode($poolstart);
				$sql = "select poolend from pool where poolid=$id";
				$result = db_query($sql);
				if (db_numrows($result) >= 1) {
					$row = db_fetch_array($result,1);
					$poolend = $row["poolend"];
				}
				else {
					$msg = $msg . "<br><b>An unexpected errors has occured. Please call the developer teams immediately.</b>";
				}

				if ($poolend <= $poolstart) {
					$msg = $msg . "<br><b>Error! The Pool Start number should be smaller than the Pool End number.</b>";
				}
				else {
					$sql = "select count(*) from pool where poolend > $poolstart";
					$result = db_query($sql);
					if (db_numrows($result) >= 1) {
						$row = db_fetch_array($result,1);
						$checkcnt = 9 - $row[0];
						if ($checkcnt <> $id) {
							$msg = $msg. "<br><b>Error! The Pool Start value has conflict with other pool number range!";
						}
						else {
							$sql = "update pool set pooldesc='$pooldesc', poolstart='$poolstart', editflag='1' where poolid=$id";
						}
					}
					else {
						$msg = $msg . "<br><b>Error! Pool table shouldn't be empty.</b>";
					}
				}
			}
			else {
				$msg = $msg . "<br><b>Invalid Pool Starting Range Entered (i.e. negative figure entered, field is not 4 digits long or contains non-numeric values)</b>";
			}
		}
		else {
			$sql = "update pool set pooldesc='$pooldesc' where poolid=$id";
		}
		
		if ($msg == "") {
			db_query($sql);
			$msg = "<br><b>Pool Record Successfully Updated!</b>";
		}
	}
?>
<html>
<head>
<title>Pool Management Form</title>
<meta content="text/html; charset=windows-1252" http-equiv=Content-Type>
<meta content=en-us http-equiv=Content-Language>
<? include($style); ?>
</HEAD>
<body bgColor=#ffffff leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
<p>&nbsp;</p>
<table width="410" border="0" cellspacing="0" cellpadding="8" align="center">
<tr valign="top"> 
	<td align="center"><font class="sub"><b>EXISTING POOL CODES</b></font></td>
</tr>
</table>
<table class="bigbox" border="0" cellspacing="0" cellpadding="0" align="center">
<tr> 
    <td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
    <td width="373"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
    <td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
</tr>
<tr> 
    <td width="16">&nbsp;</td>
    <td valign="top" class="bgline"> 
      <table cellpadding="5" cellspacing="1" border="0" align="center">
      <tr class="highlights"> 
          <td valign="top"><a href="<?=$docroot?>/<?=$poolmgt?><? echo "?sortorder=poolcode"?>"><b>Pool Code</b></a></td>
          <td valign="top"><b>Pool Description</b></td>
          <td valign="top"><a href="<?=$docroot?>/<?=$poolmgt?><? echo "?sortorder=poolend"?>"><b>Pool Range</b></a></td>
          <td valign="top"><b>Action</b></td>
      </tr>
		<?
		$sql = "select * from pool order by $Transmarco[userpoolsort]";
		$result = db_query($sql);
		if (db_numrows($result) >= 1) {
			for($x = 0; $x < db_numrows($result); $x++){
				$row = db_fetch_array($result,1);
				$poolid = $row["poolid"];
				$poolcode = $row["poolcode"];
				$pooldesc = $row["pooldesc"];
				$poolstart = $row["poolstart"];
				$poolend = $row["poolend"];				
				$pooledit = $row["editflag"];
		?>
        <tr class="tdfill"> 
			<td><?=$poolcode?></td>
			<td><?=$pooldesc?></td>
			<td>
				<table><tr><td width="46%" align="center"><?=$poolstart?></td>
				<td width="8%" align="center">-</td>
				<td width="46%" align="center"><?=$poolend?></td></tr></table></td>
			<td align="center"><a href="<?=$docroot?>/<?=$poolmgt?><? echo "?action=Update&id=" . $poolid?>">Edit</a></td>
        </tr>
		<?	}
		}?>
      </table>
    </td>
    <td width="17" align="right">&nbsp;</td>
  </tr>
  <tr> 
    <td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
    <td width="373">&nbsp;</td>
    <td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
  </tr>
</table>
<? 	
if ($action=='Update') {
	$sql = "select * from pool where poolid = $id";
	$result = db_query($sql);
	$row = db_fetch_array($result,1);
	$poolcode = $row["poolcode"];
	$pooldesc = $row["pooldesc"];
	$poolstart = $row["poolstart"];
	$poolend = $row["poolend"];
	$flag = $row["editflag"];
?>
<br>
	<table width="680" border="0" cellspacing="0" cellpadding="8" align="center">
    <tr valign="top"> 
		<td align="center"><font class="sub"><b><?=strtoupper($action)?> POOL CODE</b></font></td>
    </tr>
	<? if ($flag == '0') { ?>
	<tr>
		<td align="center">Warning! If you are to key in your Pool Start Value, you will not be able to edit it after you update the record.<br>If you accidentally update it, you will need the help of developer team to release the lock.<br>Please double confirm the value you entered before you click the Update button.</td></tr>
	<? } ?>
	<tr><td align="center"><?=$msg?></td></tr>	
	</table>
	<form method="post" action="<?=$PHP_SELF?>" name="form">
		<table width="600" border="0" cellspacing="0" cellpadding="0" bgcolor="#EEEEEE" align="center">
		<tr> 
			<td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
			<td width="563"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
			<td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
		</tr>
		<tr> 
			<td width="23">&nbsp;</td>
			<td width="563">
				<table>
				<tr>
					<td>Pool Code</td>
					<td><?=$poolcode?></td>
				</tr>
				<tr>
					<td>Pool Description</td>
					<td><input type="text" name="pooldesc" value="<?=$pooldesc?>" maxlength="200" size="30"></td>
				</tr>
				<tr>
					<td>Pool Start Value</td>
					<? if ($flag == '0') {?>
					<td><input type="text" name="poolstart" maxlength="4" size="4"> * 4 digits must be keyed in </td>
					<? } else { ?>
					<td><?=$poolstart?></td>
					<? } ?>
				</tr>
				<tr>
					<td>Pool End Value</td>						
					<td><?=$poolend?></td>
				</tr>
				</table>
			</td>
			<td width="17">&nbsp;</td>
		</tr>
		<tr valign="baseline"> 
			<td width="23">&nbsp;</td>
				<input type="hidden" name="submitted" value="yes">
				<input type="hidden" name=id value=<?=$id?>>
				<input type="hidden" name="flag" value="<?=$flag?>">
			<td width="563" align="center"><input type="submit" name="action" value="Update">&nbsp;<input type="reset" name="Reset" value="Clear">&nbsp;<input type="submit" name="action" value="Cancel"></center></td>
			<td width="17">&nbsp;</td>
		</tr>
		<tr>
			<td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
			<td width="563">&nbsp;</td>
			<td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
		</tr>
	</table>
	</form>
<? } ?>
	</body>
</html>
<?
} ?>