<?
/*
Author		: Yaw
Version		: 1.01
Date			: 29th March 2002
Function		: Group Management
*/ 

session_start();
require("auth.php");
unset($msg);

######################################################
# Determine if Access Level is adequate to view page #
######################################################
if ($Transmarco["accesslevel"] < $adminlevel) {
	authfail();
} else 	{ 

#######################################################################
# Registering Sort Order into Session                                 #
# Will control the page so that the page appears in the same sorting  #
# order everytime the user from the same browser access the same page #
#######################################################################
// First time the user access the page, automatically sort by group starting range
if (($Transmarco["usergroupsort"] == "") && ($sortorder == "")) {
	$Transmarco["usergroupsort"] = "groupstart";
}
// Subsequently when users decide on a sorting preference, store their preference into a session
if (($Transmarco["usergroupsort"] != "") && ($sortorder != "")) {
	$Transmarco["usergroupsort"] = $sortorder;
}

###################################################
# Deactivate a Group code                         #
# Updating database if user decides to Deactivate #
###################################################
if ($action == 'Deactivate') {
	$sql = "update grouptable set groupactive='N' where groupid=$id";
	db_query($sql);
	$msg = "Group Deactivated<br>";
}

#################################################
# Activating a Group code                       #
# Updating database if user decides to Activate #
#################################################
if ($action == 'Activate') {
	$sql = "update grouptable set groupactive='Y' where groupid=$id";
	db_query($sql);
	$msg = "Group Activated<br>";
}

###################################################
# Editing a Group code                            #
# Inserting into database if user decides to Edit #
###################################################
if (($action == 'Edit') && ($submitted == 'yes')) {
	// Initializing Msg Text
	$msg = "";

	// Checking if Group Description is blank when User is editing a group
	if ($groupdesc != "") {
		$groupdesc = magiccode(ucwords($groupdesc));
		$sql = "update grouptable set groupdesc='$groupdesc' where groupid=$id";
		$result = db_query($sql);
		$msg = "Group Description Successfully Updated!";
	} else {
		$msg = "Group Description Must Be Filled In";
	}
}

##################################################
# Add a Group code                               #
# Inserting into database if user decides to Add #
##################################################
if (($action == 'Add') && ($submitted == 'yes')) {
	// Initializing Msg Text
	$msg = "";

	// Checking if Group Code is valid when User is adding a group, and if valid, force both characters to uppercase
	if (ereg ("([a-zA-Z]{2})", $groupcode)) {
		// Checking to see the the existing Group Code already exists in the database
		$groupcode = magiccode(strtoupper($groupcode));
		$sql = "select * from grouptable where groupcode='$groupcode'";
		$result = db_query($sql);
		if (db_numrows($result) >= 1) {
			$msg = $msg . "The Group Code keyed in already exists in the database!<br>";
		}
	} else {
		$msg = $msg . "Invalid Group Code Entered<br>";
	}

	// Checking if Group Description is blank when User is adding a group
	if (strlen($groupdesc) != "" ) {
		$groupdesc = magiccode(ucwords($groupdesc));
	} else {
		$msg = $msg . "Invalid Group Description Entered<br>";
	}

	// Checking if Group Starting range is valid 4 (positive) digit field
	if (($groupstart > 0) && (strlen($groupstart) == 4) && (ereg ("([0-9]{4})", $groupstart)) ) {
		// Checking to see the the existing Group Start already exists in the database
		$groupstart = magiccode($groupstart);
		$sql = "select * from grouptable where groupstart ='$groupstart'";
		$result = db_query($sql);
		if (db_numrows($result) >= 1) {
			$msg = $msg . "The Group Starting Range keyed in already exists in the database!<br>";
		}
	} else {
		$msg = $msg . "Invalid Group Starting Range Entered (i.e. negative figure entered, field is not 4 digits long or contains non-numbers)<br>";
	}

	// Checking if Reserved Block Range is valid 4 (positive) digit field
	if (($groupblock > 0) && (strlen($groupblock) == 4) && (ereg ("([0-9]{4})", $groupblock)) ) {
		// Passed required tests
		$groupblock = magiccode($groupblock);
		$sql = "select * from grouptable where groupblock ='$groupblock'";
		$result = db_query($sql);
	} else {
		$msg = $msg . "Invalid Group Block Range Entered (i.e. negative figure entered, field is not 4 digits long or contains non-numbers)<br>";
	}

	// Checking to ensure that the range of reserved numbers does not overlap into another Group
	// Checking to see if opening range fits into another group's defined range
	// Defining the range that the user has keyed in to be reserved for group just added (i.e. $groupstart - $grouprange)
	$grouprange = $groupstart + $groupblock - 1; 
	$sql = "select * from grouptable order by groupstart";
	$result = db_query($sql);
	for($x = 0; $x < db_numrows($result); $x++){
		$row = db_fetch_array($result,1);
		$currentgroupstart = $row["groupstart"];
		$currentgroupblock = $row["groupblock"];
		$currentgrouprange = $currentgroupstart + $currentgroupblock - 1;
		if (($groupstart >= $currentgroupstart) && ($groupstart <= $currentgrouprange)){
			$msg = $msg . "Specified Group Starting Range is in a reserved block in use by another Group<br>";
		}
		if (($grouprange >= $currentgroupstart) && ($grouprange <= $currentgrouprange)){
			$msg = $msg . "Specified Group Ending Range is in a reserved block in use by another Group<br>";
		}
	}

	// If no messages are stored up until this point, all data entered is valid, Proceed with insertion
	if ($msg == "") {
		$newid = magiccode(find_new_id("groupid","grouptable"));
		$sql = "insert into grouptable (`groupid`,`groupcode`,`groupdesc`,`groupstart`,`groupblock`,`groupactive`) values('$newid','$groupcode','$groupdesc','$groupstart','$groupblock','Y')";
		db_query($sql);
		$msg = "Group " . $groupcode . " Created";
		unset($groupid);
		unset($groupcode);
		unset($groupdesc);
		unset($groupstart);
		unset($groupblock);
		unset($groupactive);
	} else {
		$msg = $msg . "<br>Creation of New Group Failed!";
	}
}
###############################
# HTML FOR FIRST TABLE ON TOP #
###############################
?>
<HTML>
	<HEAD>
		<TITLE>Group Management Form</TITLE>
		<META content="text/html; charset=windows-1252" http-equiv=Content-Type>
		<META content=en-us http-equiv=Content-Language>
		<? include($style); ?>
	</HEAD>
	<BODY bgColor=#ffffff leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<center><b>EXISTING GROUP CODES</b></center>
	<br>
	<table border="0" cellspacing="0" cellpadding="0" bgcolor="#EEEEEE" align="center">
		<tr> 
			<td width="16" height="16" valign="top" align="left"><img src="<? echo $images ?>a.gif" width="16" height="18"></td>
			<td width="763"><img src="<? echo $images ?>shim.gif" width="16" height="16"></td>
			<td width="17" height="16" align="right" valign="top"><img src="<? echo $images ?>b.gif" width="16" height="16"></td>
		</tr>
		<tr> 
			<td width="16">&nbsp</td>
			<td valign="top" bgcolor="#CCCCCC" width="763">
			<table cellpadding="5" cellspacing="1" border="0" align="center">
					<tr bgcolor="#EEEEEE">
						<td width="10%" align="left"><a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?sortorder=groupcode"?>"><b>Group Code</b></a></td>
						<td width="60%" align="center"><b>Group Description</b></td>
						<td width="15%" align="left"><a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?sortorder=groupstart"?>"><b>Group Starting Range Number</b></a></td>
						<td width="15%" align="right"><b>Action</b></td>
					<tr>
					<? 
					//  Generating Existing Group Codes
					$sql = "select * from grouptable order by $Transmarco[usergroupsort]";
					$result = db_query($sql);
					for($x = 0; $x < db_numrows($result); $x++){
						$row = db_fetch_array($result,1);
						$currentgroupid = $row["groupid"];
						$currentgroupcode = $row["groupcode"];
						$currentgroupdesc = $row["groupdesc"];
						$currentgroupstart = $row["groupstart"];
						$currentgroupblock = $row["groupblock"];
						$currentgrouprange = $currentgroupstart + $currentgroupblock - 1;
						$currentgroupactive = $row["groupactive"];

					?>
						<tr bgcolor="#FFFFFF">
							<td width="10%" align="left"><? echo $currentgroupcode ?></td>
							<td width="60%" align="left"><? echo $currentgroupdesc ?></td>
							<td width="15%" align="left"><? echo $currentgroupstart . " - " . $currentgrouprange ?></td>
							<td width="15%" align="right"><a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?action=Edit&id=" . $currentgroupid ?>">Edit</a>
					<? 
					// Generating the Activate or Deactivate action
					if ($currentgroupactive == "Y") {				
					?>
							&nbsp<a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?action=Deactivate&id=" . $currentgroupid ?>"> Deactivate </a></td>
					<? } else { ?>
							&nbsp<a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?action=Activate&id=" . $currentgroupid ?>"> Activate </a></td>
					<? } ?>
						<tr>

					<? } ?>
				</table>
			</td>
			<td width="17">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left">&nbsp</td>
			<td width="763">&nbsp</td>
			<td width="17" align="right" valign="bottom">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left">&nbsp</td>
			<td width="763"><center><a href="<? echo $docroot ?>/<? echo $groupmgt ?><? echo "?action=Add" ?>">Add New Group Code</center></td>
			<td width="17" align="right" valign="bottom">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left"><img src="<? echo $images ?>c.gif" width="16" height="18"></td>
			<td width="763">&nbsp;</td>
			<td width="17" align="right" valign="bottom"><img src="<? echo $images ?>d.gif" width="16" height="16"></td>
		</tr>
	</table>

<? 	
##################################
# HTML FOR FIRST TABLE AT BOTTOM #
##################################

	if (($action == 'Edit') || ($action == 'Add')){ 
	// Prefilling the fields in the form with values from db
	if ($action=='Edit') {
		$sql = "select * from grouptable where groupid = $id";
		$result = db_query($sql);
		for($x=0; $x<db_numrows($result); $x++){
			$row = db_fetch_array($result,1);
			$groupcode = $row["groupcode"];
			$groupdesc = $row["groupdesc"];
			$groupstart = $row["groupstart"];
			$groupblock = $row["groupblock"];
		}
	}
?>
	<br><br><br>
	<center><b><? echo strtoupper($action) ?> GROUP CODE</b></center>
	<br>
	<center><? echo $msg ?></center>
		<form method="post" action="<? echo $PHP_SELF ?>" name="form">
			<table width="600" border="0" cellspacing="0" cellpadding="0" bgcolor="#EEEEEE" align="center">
				<tr> 
					<td width="16" height="16" valign="top" align="left"><img src="<? echo $images ?>a.gif" width="16" height="18"></td>
					<td width="563"><img src="<? echo $images ?>shim.gif" width="16" height="16"></td>
					<td width="17" height="16" align="right" valign="top"><img src="<? echo $images ?>b.gif" width="16" height="16"></td>
				</tr>
				<tr> 
					<td width="23">&nbsp</td>
					<td width="563">
						<table>
							<tr>
								<td>Group Code</td>
								<? if ($action == 'Add') {?>
								<td><input type="text" name="groupcode" value="<? echo $groupcode ?>" maxlength="2" size="2"> * The System will input this in uppercase</td>
								<? } ?>
								<? if ($action == 'Edit') {?>
								<td><? echo $groupcode ?></td>
								<? } ?>
							</tr>
							<tr>
								<td>Group Description</td>
								<td><input type="text" name="groupdesc" value="<? echo $groupdesc ?>" maxlength="200" size="65"></td>
							</tr>
							<tr>
								<td>Group Starting Range</td>
								<? if ($action == 'Add') {?>
								<td><input type="text" name="groupstart" value="<? echo $groupstart ?>" maxlength="4" size="4"> * 4 digits must be keyed in </td>
								<? } ?>
								<? if ($action == 'Edit') {?>
								<td><? echo $groupstart ?></td>
								<? } ?>
							</tr>
							<tr>
								<td>Reserved Block Range</td>
								<? if ($action == 'Add') {?>
								<td><input type="text" name="groupblock" value="<? echo $groupblock ?>" maxlength="4" size="4"> * Number of reserved slots; 4 digits must be keyed in </td>
								<? } ?>
								<? if ($action == 'Edit') {?>
								<td><? echo $groupblock ?></td>
								<? } ?>
							</tr>
						</table>
					</td>
					<td width="17">&nbsp</td>
				</tr>
				<tr valign="baseline"> 
					<td width="23">&nbsp</td>
						<input type="hidden" name="submitted" value="yes">
					<? if ($action == "Edit") { ?>
						<input type="hidden" name=id value=<? echo $id ?>>
					<? } ?>
					<td width="563"><center><input type="submit" name="action" value="<? echo ucwords($action) ?>">&nbsp<input type="reset" name="Reset" value="Clear">&nbsp<input type="submit" name="action" value="Cancel"></center></td>
					<td width="17">&nbsp</td>
				</tr>
				<tr> 
					<td width="16" valign="bottom" align="left"><img src="<? echo $images ?>c.gif" width="16" height="18"></td>
					<td width="563">&nbsp;</td>
					<td width="17" align="right" valign="bottom"><img src="<? echo $images ?>d.gif" width="16" height="16"></td>
				</tr>
			</table>
		</form>
<? } ?>
	</BODY>
</HTML>
<? } ?>
